<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Users()
    {
        return $this->hasMany('App\models\CompanyUser');
    }

    public function protfolios()
    {
        return $this->hasMany('App\models\Protfolio');
    }

}